--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	~MENTALRAY_PHYS_SKY~
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	3088 --Texture
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x628e269eL, 0x72386abfL) --mr Physical Sky
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~PHYS_SUN_SKY~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3088 --Texture
)

--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x223349b4L, 0x562a7d8bL) --Physical Sun & Sky Environment
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

fn ConvertMrPhysicalSkyToPhysicalSunSky mrMap physSunSky =
(
	if((false == (iskindof mrMap mr_Physical_Sky)) OR
	   (false == (iskindof physSunSky Physical_Sun___Sky_Environment))) do
	(
	   return undefined
	)
	
	--Let the sun enabled
	
	physSunSky.sun_disc_intensity = mrMap.SunIntensity
	if(mrMap.SunIntensity.controller != undefined) do physSunSky.sun_disc_intensity.controller = mrMap.SunIntensity.controller
	
	physSunSky.sun_glow_intensity = mrMap.SunGlow
	if(mrMap.SunGlow.controller != undefined) do physSunSky.sun_glow_intensity.controller = mrMap.SunGlow.controller
	
	physSunSky.sun_disc_scale = mrMap.SunScale
	if(mrMap.SunScale.controller != undefined) do physSunSky.sun_disc_scale.controller = mrMap.SunScale.controller
	
	if (false == mrMap.InheritFromSky) do
	(
		physSunSky.global_intensity = mrMap.multiplier
		if(mrMap.multiplier.controller != undefined) do physSunSky.global_intensity.controller = mrMap.multiplier.controller

		physSunSky.sky_intensity = 1.0
					
		physSunSky.haze = mrMap.Haze / 15.0
		--if(mrMap.Haze.controller != undefined) do physSunSky.haze.controller = mrMap.Haze.controller
		
		physSunSky.night_color = mrMap.NightColor
		if(mrMap.NightColor.controller != undefined) do physSunSky.night_color.controller = mrMap.NightColor.controller
	
		physSunSky.night_intensity = 1.0	
		
		physSunSky.ground_color = mrMap.GroundColor
		if(mrMap.GroundColor.controller != undefined) do physSunSky.ground_color.controller = mrMap.GroundColor.controller
		
		physSunSky.horizon_height_deg = asin (mrMap.HorizonHeight * 0.1)
		physSunSky.horizon_blur_deg = asin (mrMap.HorizonBlur * 0.1)		
				
		physSunSky.saturation = mrMap.Saturation
		if(mrMap.Saturation.controller != undefined) do physSunSky.saturation.controller = mrMap.Saturation.controller 
		
		local c = Point4 (1.0 + mrMap.Redness) 1.0 (1.0 - mrMap.Redness) 1.0
		physSunSky.tint  = (c as Color)
	) 
)

fn InstallPhysicalSunAndSkyEnvMap =
(
--The code that install the environmap in the sun positioner, also configure the Exposure control, I don't know if this should also be done here.
--I am currently assuming that the exposure control will be set per another script.

	--Check if Physical Sun and Sky environment map is not already configured... 
	if ((environmentMap == undefined) or 
		((environmentMap.classid as string) != (Physical_Sun___Sky_Environment.classid as string))) do
	( -- if not, configure a new map
	
		local physSunSkyEnv = Physical_Sun___Sky_Environment name:Physical_Sun___Sky_Environment.localizedName --Not sure if it is the correct name	
		environmentMap = physSunSkyEnv 
		useEnvironmentMap = true
	) 
	
	--Note: this does not set a sun positioner.

	environmentMap
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not use*/ =
(
	local physSky = InstallPhysicalSunAndSkyEnvMap()
		
	--return the environment map
	physSky	

)

--Main entry point from this script
--This function handles the creation of the sky if necessary, and transfer from the skylight to the environment map.
fn Conversion legacySky =
(
	if (false == VerifySource legacySky)  do
	(
		--Not the suitable node
		return undefined
	)	
	
	physSky = InstallPhysicalSunAndSkyEnvMap()
	
	ConvertMrPhysicalSkyToPhysicalSunSky legacySky physSky
	
	if (IsProperty legacySky "name") and (undefined != legacySky.name) and (String == classof legacySky.name)  and (IsProperty physSky "name") do
    (
        physSky.name = legacySky.name
    )

	--return the environment map
	physSky	
)